uniform sampler2D s_tex0;
uniform float radius;
uniform vec2 position; //beacon position in screen coords
uniform float time;
uniform float burning;

float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(1.29898,.78233))) * 43758.5453);
}

void main()
{
	float darken = 15.6;
	float roughness = 0.15;
	float wetmix = 0.85;
	float bloomness = 0.3;

	float factor  = 1.-clamp(length(gl_FragCoord.xy - position ) / radius , 0., 1.);
	factor = clamp(factor,0., 1.);

	vec4 color = gl_Color * texture2D(s_tex0, gl_TexCoord[0].xy);
	
	// bloom effect inspired by http://kstudios.de/postprocessing2_3.php
	vec3 origColor = color.rgb;
	color.rgb = color.rgb*color.rgb;

	// average is darkened via factor
	float avg = (color.r+color.g+color.b)/3.0;
	avg = avg * (1.0-roughness) + avg * rand(gl_FragCoord.xy*time)*roughness;
	vec3 avgcolor = vec3(avg,avg,avg);

	// bloom inside, drown outside
	color.rgb = mix(avgcolor/darken, origColor, factor);

	// feed it back according to http://kstudios.de/postprocessing2_3.php
	color.rgb = mix(color.rgb,color.rgb*color.rgb, bloomness*factor);
	color.rgb += avgcolor*burning;

	color.rgb = mix(origColor,color.rgb, wetmix);

	gl_FragColor = color;
}
